#ifndef _DEVINFO_H_
#define _DEVINFO_H_

#include <string>

typedef enum
{
    VPLUS     = 0,
    HIKVISION = 1
};

typedef enum
{
    DEVICE_DVR = 0,
    DEVICE_IPC = 1,
    DEVICE_MEDIASERVER = 2
};

typedef enum
{
	REGMODE_NORMALIP = 0,
    REGMODE_NORAMLDOMAIN = 1,
	REGMODE_PRIVATEDOMAIN = 2
};

class CDevInfo
{
public:
    CDevInfo();
	CDevInfo(std::string strName, std::string strIP, int iPort, std::string strUserName, std::string strPwd,
		int iChnNum, std::string strMultiIP, std::string strDns, std::string strSN, std::string strManfacture,
		int iManfactureID, int iAddrType, int iDevType, std::string strGuid, std::string strRegionGuid, int iNetworkType);
    CDevInfo(const CDevInfo& devInfo);
    CDevInfo& operator = (const CDevInfo& devInfo);
	void SetDevName(std::string strName){m_strName = strName; }
    const char *GetDevName(void) { return m_strName.c_str(); }
	std::string GetDevName2() { return m_strName;}
	void SetIPAddr(std::string strDevAddr){m_strIP = strDevAddr; }
    const char *GetIPAddr() { return m_strIP.c_str(); }
	void SetUserName(std::string strUserName){m_strUserName = strUserName; }
    const char *GetUserName() { return m_strUserName.c_str(); }
	void SetPassWord(std::string strPassword) { m_strPwd = strPassword; }
    const char *GetPassWord() { return m_strPwd.c_str(); }
	void SetMultIPAddr(std::string strMultIPAddr) { m_strMultiIP = strMultIPAddr;} 
    const char *GetMultIPAddr() { return m_strMultiIP.c_str();} 
	void SetDNSAddr(std::string strDNSAddr) { m_strDns = strDNSAddr; }
    const char *GetDNSAddr() { return m_strDns.c_str(); }
	void SetManufacture(std::string strManufacture) { m_strManfacture = strManufacture; }
    const char *GetManufacture() { return m_strManfacture.c_str(); }
	void SetManufactureID(int iManfactureID) {m_iManfactureID = iManfactureID; }
	int GetManufactureID() {return m_iManfactureID;}
	void SetGuid(std::string strGuid) { m_strGuid = strGuid; }
	const char *GetGuid() const { return m_strGuid.c_str(); }
	void SetRegionGuid(std::string strRegionGuid) { m_strRegionGuid = strRegionGuid; }
    const char *GetRegionGuid() const { return m_strRegionGuid.c_str(); }
	void SetPort(int iPort){m_iPort = iPort; }
    int GetPort() { return m_iPort; }
	void SetChannelNum(int iChannel) { m_iChnNum = iChannel; }
    int GetChannelNum() { return m_iChnNum; }
	void SetSerialNum(std::string strSN) { m_strSN = strSN; }
    const char* GetSerialNum() { return m_strSN.c_str(); }
	void SetDeviceType(int iDeviceType) {m_iDevType = iDeviceType; }
	void SetNetworkType(int iNetworkType) {m_iNetworkType = iNetworkType; }
    int GetDeviceType() const { return m_iDevType; }
	int GetNetworkType() const { return m_iNetworkType; }
	void SetAddrType(int iAddrType){m_iAddrType = iAddrType; }
    int GetAddrType() const { return m_iAddrType; }


    void Copy(const CDevInfo& devInfo);
private:
	std::string m_strName; 
	std::string m_strIP; 
	int m_iPort; 
	std::string m_strUserName; 
	std::string m_strPwd;
	int m_iChnNum; 
	std::string m_strMultiIP; 
	std::string m_strDns; 
	std::string m_strSN; 
	std::string m_strManfacture;
	int m_iManfactureID;
	int m_iAddrType;
	int m_iDevType;
	int m_iNetworkType;
	std::string m_strGuid; 
	std::string m_strRegionGuid;
};

#endif
